(*-------------------------------------------------------------------------------------*)
(*                                                                                     *)
(*               Unit: Main                                                            *)
(*                                                                                     *)
(*               Copyright McCallum Whyman Associates Ltd 1996                         *)
(*                                                                                     *)
(*               Version 1.0                                                           *)
(*                                                                                     *)
(*               Author: Tony Whyman                                                   *)
(*                                                                                     *)
(*               Description: This module is part of the J-Write example application   *)
(*                            and defines the main form for the MDI editor.            *)
(*-------------------------------------------------------------------------------------*)

unit Main;

interface

uses WinTypes, WinProcs, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, FileView;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    Panel1: TPanel;
    StatusLine: TPanel;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    ModifiedPanel: TPanel;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog: TOpenDialog;
    WindowMinimizeItem: TMenuItem;
    SpeedPanel: TPanel;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    CutBtn: TSpeedButton;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    StatusPanel: TPanel;
    ProgressMeter1: TProgressMeter;
    InsertPanel: TPanel;
    PrintBtn: TSpeedButton;
    LineCounter: TPanel;
    WrapNoneBtn: TSpeedButton;
    WrapScreenBtn: TSpeedButton;
    WrapPrinterBtn: TSpeedButton;
    WrapAbsBtn: TSpeedButton;
    PrinterSetupDialog1: TPrinterSetupDialog;
    N2: TMenuItem;
    PrintSetup1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FileNewItemClick(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure FileSaveItemClick(Sender: TObject);
    procedure FileSaveAsItemClick(Sender: TObject);
    procedure CutItemClick(Sender: TObject);
    procedure CopyItemClick(Sender: TObject);
    procedure PasteItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure PrintBtnClick(Sender: TObject);
    procedure WrapNoneBtnClick(Sender: TObject);
    procedure WrapScreenBtnClick(Sender: TObject);
    procedure WrapPrinterBtnClick(Sender: TObject);
    procedure WrapAbsBtnClick(Sender: TObject);
    procedure PrintSetup1Click(Sender: TObject);
  private
    { Private declarations }
    procedure CreateMDIChild(const Name: string);
    procedure ShowHint(Sender: TObject);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses ChildWin, About;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
  AboutBox := TAboutBox.Create(Self);
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusPanel.Caption := Application.Hint;
end;

procedure TMainForm.CreateMDIChild(const Name: string);
var
  Child: TMDIChild;
begin
  { create a new MDI child window }
  Child := TMDIChild.Create(Application);
  Child.Caption := Name;
  Child.FileEditor1.FileName := Name
end;

procedure TMainForm.FileNewItemClick(Sender: TObject);
var
  Child: TMDIChild;
begin
  { create a new MDI child window }
  Child := TMDIChild.Create(Application);
  Child.Caption := 'NONAME' + IntToStr(MDIChildCount);
end;

procedure TMainForm.FileOpenItemClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    CreateMDIChild(OpenDialog.FileName);
end;

procedure TMainForm.FileCloseItemClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

procedure TMainForm.FileSaveItemClick(Sender: TObject);
begin
  { save current file (ActiveMDIChild points to the window) }
     With ActiveMDIChild As TMDIChild Do
          Save1Click(Sender)
end;

procedure TMainForm.FileSaveAsItemClick(Sender: TObject);
begin
  { save current file under new name }
     With ActiveMDIChild As TMDIChild Do
          SaveAs1Click(Sender)
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.CutItemClick(Sender: TObject);
begin
  {cut selection to clipboard}
     With ActiveMDIChild As TMDIChild Do
          Cut1Click(Sender)
end;

procedure TMainForm.CopyItemClick(Sender: TObject);
begin
  {copy selection to clipboard}
     With ActiveMDIChild As TMDIChild Do
          Copy1Click(Sender)
end;

procedure TMainForm.PasteItemClick(Sender: TObject);
begin
  {paste from clipboard}
     With ActiveMDIChild As TMDIChild Do
          Paste1Click(Sender)
end;

procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMainForm.UpdateMenuItems(Sender: TObject);
begin
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  WindowTileItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled := MDIChildCount > 0;
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

procedure TMainForm.HelpAboutItemClick(Sender: TObject);
begin
     AboutBox.Show
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  AboutBox.ShowModal
end;

procedure TMainForm.PrintBtnClick(Sender: TObject);
begin
     With ActiveMDIChild As TMDIChild Do
          Print1Click(Sender)
end;

procedure TMainForm.WrapNoneBtnClick(Sender: TObject);
begin
     With ActiveMDIChild As TMDIChild Do
          FileEditor1.WrapMode := opNone
end;

procedure TMainForm.WrapScreenBtnClick(Sender: TObject);
begin
     With ActiveMDIChild As TMDIChild Do
          FileEditor1.WrapMode := opWrapScreenWidth

end;

procedure TMainForm.WrapPrinterBtnClick(Sender: TObject);
begin
     With ActiveMDIChild As TMDIChild Do
          FileEditor1.WrapMode := opPrinter

end;

procedure TMainForm.WrapAbsBtnClick(Sender: TObject);
begin
     With ActiveMDIChild As TMDIChild Do
          FileEditor1.WrapMode := opAbsoluteWrap

end;

procedure TMainForm.PrintSetup1Click(Sender: TObject);

var I: integer;

begin
     PrinterSetupDialog1.Execute;
     For I := 1 to MDIChildCount Do
         If MDIChildren[I] is TMDIChild Then
            TMDIChild(MDIChildren[I]).FileEditor1.HandlePrinterChange(Sender)
end;

end.
